/* **************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW W83B.W83BDATOSINCIDENCIAS (NACTA, TERRIT, ANOACTA, VER, NREGDEF, ANOREGDEF, FECHABAJA, FECHAREGISTRO, FELEC, FECHAINCIDENCIA, FECHAVALIDACION) AS 
  SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
            actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
            actas.n_regdef_016 AS nregdef, ano_regdef_016 AS anoregdef,
            actas.f_baja_016 AS fechabaja, actas.fregdef_016 AS fecharegistro,
            actas.f_elecc_016 AS felec,
             incidencias.f_entrada_061 AS fechaincidencia,
            incidencias.f_validac_061 AS fechavalidacion
        FROM w83b16s00 actas,
            w83b61s00 incidencias      
        WHERE actas.n_acta_016 = incidencias.n_acta_061
        AND actas.ano_acta_016 = incidencias.ano_acta_061
        AND actas.c_territ_016 = incidencias.c_territ_061
        AND actas.version_016 = incidencias.version_acta_061
        AND actas.validada_016 = 1
        AND actas.n_regdef_016 IS NOT NULL
        AND actas.n_acttot_016 IS NULL
   GROUP BY actas.n_acta_016,
            actas.c_territ_016,
            actas.ano_acta_016,
            actas.version_016,
            actas.n_acttot_016,
            actas.f_baja_016,
            actas.fregdef_016,
            actas.f_elecc_016,
            incidencias.f_entrada_061,
            incidencias.f_validac_061,
            actas.n_regdef_016,
            ano_regdef_016
   ORDER BY nacta, territ, anoacta, ver DESC;
/
/* *************************************************************************************************** */
